function turn_on_cargando(){
  boton = document.getElementById("cargador");
  boton.style.display='block';
}

function turn_off_cargando(){
  boton = document.getElementById("cargador");
  boton.style.display='none';
}

function messageConfirmation(message,type){
	Swal.fire(
		'Aviso',
		message,
		type
	);
}

function redirection(route){
	setInterval(function(){ location.href = route; }, 2000);
}

function message(title,type){
	Swal.fire({
	  position: 'top-center',
	  icon: type,
	  title: title,
	  showConfirmButton: false,
	  timer: 2000,
      // width: '3000px',
      // height: '1000px'
      className: 'swal-wide'
	});
}

function toast(message, type) {
	if (type === "error") {
		var color = "red"
	} else {
		var color = "green";
	}

	const Toast = Swal.mixin({
		toast: true,
		position: 'top',
		showConfirmButton: false,
		timer: 3000,
		timerProgressBar: true,
		background: color,
		// customClass: {title: 'toast'},
		// html: true,
		didOpen: (toast) => {
			toast.addEventListener('mouseenter', Swal.stopTimer)
			toast.addEventListener('mouseleave', Swal.resumeTimer)
		}
	});

	Toast.fire({
		icon: type,
		title: "<span style='color: white;'>" + message + "</span>"
	});
}

function setDataTables(tabla){
  $(tabla).DataTable().destroy();
  $(tabla).DataTable( {
  	  retrive: true,
  	  destroy: true,
  	  "order": [[ 0, "desc" ]],
      language: {
          search: "B&uacute;squeda:",
          processing:    "Traitement en cours...",
          lengthMenu:    "Filtrar _MENU_ registros",
          info:           "_START_ - _END_ de _TOTAL_ registros",
          infoEmpty:      "No hay resultados",
          infoFiltered:   "(filtro de _MAX_ registros)",
          infoPostFix:    "",
          loadingRecords: "Chargement en cours...",
          zeroRecords:    "No se encontr&oacute; resultado de esta b&uacute;squeda",
          emptyTable:     "Aucune donne disponible dans le tableau",
          paginate: {
              first:      "Inicio",
              previous:   "Anterior",
              next:       "Siguiente",
              last:       "Final"
          },
          aria: {
              sortAscending:  ": activer pour trier la colonne par ordre croissant",
              sortDescending: ": activer pour trier la colonne par ordre d���croissant"
          }
      }
  } );
}

function galeria_producto_inventario(id_producto, id_inventario){
	if ($('#galeria_' + id_inventario).val()!="") {

		turn_on_cargando();

		var form_data = new FormData();

		var totalfiles = document.getElementById('galeria_' + id_inventario).files.length;
		for (var index = 0; index < totalfiles; index++) {
		  form_data.append("galeria[]", document.getElementById('galeria_' + id_inventario).files[index]);
		}

		form_data.append('id_producto',id_producto);
		form_data.append('work','galeria_producto_inventario');
		form_data.append('id_inventario',id_inventario);

		console.log(JSON.stringify(form_data));
		console.log(form_data.get('id_producto'));
		console.log(form_data.get('work'));
		console.log(form_data.get('id_inventario'));
		console.log(form_data);

		$.ajax({
			url: '../process/controlador-imgs.php', 
			type: 'POST',
			data: form_data,
			// dataType: 'json',
			contentType: false,
			processData: false,
			beforeSend: function () {

	        },
	        error:  function (err) {
	            messageConfirmation("ERROR, al conectarse al SERVIDOR..." + JSON.stringify(err),"error");
	            turn_off_cargando();
	        },
			success: function (data) {
				console.log("data: " + JSON.stringify(data));
				turn_off_cargando();

			}
		});

	}else{
		message("Completa todos los datos.","error");
	}

}

function imagenes(imagen,work,id){

	if ($('#' + imagen).val() != '') {
		var fd = new FormData();
		var files = $('#' + imagen)[0].files[0];
		fd.append('imagen',files);
		fd.append('id',id);
		fd.append('work',work);

		console.log(JSON.stringify(fd));
		console.log(fd.get(imagen));
		console.log(fd);

		turn_on_cargando();

		$.ajax({
			data: fd,
			url:   './system/process/controlador-imgs.php',
			type: 'POST',    
	        contentType: false,
	        processData: false,
	        beforeSend: function () {

	        },
	        error:  function () {
	        	messageConfirmation("ERROR, al conectarse al SERVIDOR...","error");
	            turn_off_cargando();
	        },
	        success: function(data){
	        	turn_off_cargando();
	        	console.log("data img: " + data);

	        	if (data==="done") {

	        	}else{
					messageConfirmation(data,"error");
	        	}
	        }
	    });
	}else{
		message("Selecciona la imagen.","error");
	}
}

function closemodal(){
	$('#modal1').modal('hide');
	$('.modal-backdrop').hide();
}

function formulario() {
	if ($('#nombre_agencia').val()!="" 
		&& $('#razon_social').val()!=""
		&& $('#calle').val()!=""
		&& $('#rfc').val()!=""
		&& $('#no_exterior').val()!=""
		&& $('#colonia').val()!=""
		&& $('#c_p').val()!=""
		&& $('#municipio').val()!=""
		&& $('#telefono1').val()!=""
		&& $('#nombre').val()!=""
		&& $('#apellido_p').val()!=""
		&& $('#cargo').val()!=""
		&& $('#sexo').val()!=""
		&& $('#clave_usuario').val()!=""
		&& $('#contrasena').val()!=""
		&& $('#verificar_contrasena').val()!=""
	) {

		let nombre_agencia = $('#nombre_agencia').val();
		let razon_social   = $('#razon_social').val();
		let pagina_web     = $('#pagina_web').val();
		let calle          = $('#calle').val();
		let rfc            = $('#rfc').val();
		let no_exterior    = $('#no_exterior').val();
		let no_interior    = $('#no_interior').val();
		let colonia        = $('#colonia').val();
		let c_p            = $('#c_p').val();
		let municipio      = $('#municipio').val();
		let estado         = $('#estado').val();
		let ciudad         = $('#ciudad').val();
		let pais           = $('#pais').val();
		let telefono1      = $('#telefono1').val();
		let telefono2      = $('#telefono2').val();
		let nombre         = $('#nombre').val();
		let apellido_p     = $('#apellido_p').val();
		let apellido_m     = $('#apellido_m').val();
		let cargo          = $('#cargo').val();
		let sexo           = $('#sexo').val();
		let email          = $('#email').val();
		let clave_usuario  = $('#clave_usuario').val();
		let contrasena     = $('#contrasena').val();
		let skype          = $('#skype').val();
		let verificar_contrasena = $('#verificar_contrasena').val();

		if(contrasena == verificar_contrasena){

			turn_on_cargando();
				
			let data = "tarea=formulario"
				     + "&nombre_agencia=" + nombre_agencia
				     + "&razon_social=" + razon_social
				     + "&pagina_web=" + pagina_web
				     + "&calle=" + calle
				     + "&rfc=" + rfc
				     + "&no_exterior=" + no_exterior
				     + "&no_interior=" + no_interior
				     + "&colonia=" + colonia
				     + "&c_p=" + c_p
				     + "&municipio=" + municipio
				     + "&estado=" + estado
				     + "&ciudad=" + ciudad
				     + "&pais=" + pais
				     + "&telefono1=" + telefono1
				     + "&telefono2=" + telefono2
				     + "&nombre=" + nombre
				     + "&apellido_p=" + apellido_p
				     + "&apellido_m=" + apellido_m
				     + "&cargo=" + cargo
				     + "&sexo=" + sexo
				     + "&email=" + email
				     + "&clave_usuario=" + clave_usuario
				     + "&skype=" + skype
				     + "&contrasena=" + contrasena;
			console.log(data);

			$.ajax({
		        data:  data,
		        url:   './system/process/controlador.php',
		        type:  'POST',
		        beforeSend: function () {

		        },
		        error:  function () {
		            messageConfirmation("ERROR, al conectarse al SERVIDOR...","error");
		            turn_off_cargando();
		        },
		        success: function(data){
		        	turn_off_cargando();
		        	
		        	if (data === "registered") {
		        		message("Formulario registrado...","success");
		        		redirection('');
		        	}else{
		        		message(data,"error");
		        	}
		        }
		   });

		}else{
			message("Verifica tu contraseña.","info");
		}
	}else{
		message("Completa los datos solicitados.","error");
	}
}

function login() {
	if ($('#usuario').val()!="" 
		&& $('#password').val()!=""
	) {

		let usuario  = $('#usuario').val();
		let password = $('#password').val();

		turn_on_cargando();
			
		let data = "tarea=login"
			     + "&usuario=" + usuario
			     + "&password=" + password;
		console.log(data);

		$.ajax({
	        data:  data,
	        url:   './system/process/controlador.php',
	        type:  'POST',
	        beforeSend: function () {

	        },
	        error:  function () {
	            messageConfirmation("ERROR, al conectarse al SERVIDOR...","error");
	            turn_off_cargando();
	        },
	        success: function(data){
	        	turn_off_cargando();
	        	console.warn("RESPONSE: ", data);
	        	var data_check = data.split("|");
	        	
	        	if (data_check[0] === "exist") {
	        		message("Accediendo...","success");
					localStorage.setItem('id_agencia', data_check[1]);
					localStorage.setItem('token_agencia', "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6Mjc4LCJub21icmUiOiJNQVhJTiBUT1JSRVMgTUVKSUEiLCJub21icmVfYWdlbmNpYSI6IkNsaWVudGUgRmluYWwgQXp1bCIsImFnZW5jaWFzX3pvbmFzX2lkIjoiMCIsImNvcnJlbyI6IkdFUkVOQ0lBQHF1YWxpdHlzZXJ2aWNlLmNvbS5teCIsImNvbnRyYXNlbmEiOiJRUy0yMDIyIiwidGVsZWZvbm8iOiI0NzYgNzQzIDU4MTMiLCJjcmVkaXRvIjoiMCIsImNvbWlzaW9uIjoiMTUiLCJjYWxsZSI6IkNPTkNFUENJT04gTm8uIDIzMyBMLUQiLCJudW1faW50ZXJubyI6bnVsbCwibnVtX2V4dGVybm8iOm51bGwsImNvbG9uaWEiOiJTQU4gRlJBTkNJU0NPIERFTCBSSU5DXHUwMGQzTiIsImNvZGlnb19wb3N0YWwiOiIzNjMwMCIsImNpdWRhZCI6IlNBTiBGUkFOQ0lTQ08gREVMIFJJTkNcdTAwZDNOIiwiZXN0YWRvIjoiR1VBTkFKVUFUTyIsImVudHJlX2NhbGxlcyI6bnVsbCwibG9nbyI6bnVsbCwiYm9ycmFkbyI6IjEiLCJwcmltZXJhX2VudHJhZGEiOm51bGwsInN0YXR1c19zZXNzaW9uIjpudWxsLCJpbmljaW9zZXNpb24iOm51bGwsInRlbGVmb25vc19leHRyYXMiOm51bGwsInBlcm1pc29fYWN0aXZpZGFkIjoic2kiLCJ2ZXJfcGFnb3MiOm51bGwsInJmYyI6bnVsbCwiYmxvcXVlb183MiI6InNpIiwibGF0IjpudWxsLCJsbmciOm51bGwsInRpcG8iOiJhZ2VuY2lhIn0.fhYF7no2RcysRt8j8T1l3T3ECRnwYYmX5aMWaLYj9zQ");
					localStorage.setItem('cmp_agencias', data_check[2]);
					
					// redirection("https://agencia.qualityservice.mx/logear/" + data_check[1]);
					redirection("https://reservas.qualityservice.mx/hotel");
					// window.open("https://agencia.qualityservice.mx/logear/" + data_check[1]);

	        	}else{
	        		message(data,"error");
	        	}
	        }
	   });
	}else{
		message("Completa los datos solicitados.","error");
	}
}

function guardar_evidencia(){
	if ($('#nombre_agencia').val()!=''
		&& $('#email').val()!=''
		&& $('#reservacion').val()!=''
		&& $('#grupo').val()!=undefined
		&& $('#forma_pago').val()!=undefined
		&& $('#referencia_bancaria').val()!=''
		&& $('#fecha').val()!=''
		&& $('#observaciones').val()!=''
		&& $('#check-factura-si').val()!=''
		&& $('#check-factura-no').val()!=''
		&& $('#cuenta_bancaria').val()!=''
		&& $('#monto').val()!=''
		&& $('#imagen').val()!=''){

		let factura;

		let check_factura_si = document.getElementById('check-factura-si');
		let check_factura_no = document.getElementById('check-factura-no');
		if(check_factura_si.checked==true){
			factura = "Si";
		}else{
			factura = "No";
		}

		let nombre_agencia      = $('#nombre_agencia').val();
		let email               = $('#email').val();
		let reservacion         = $('#reservacion').val();
		let cuenta_bancaria     = $('#cuenta_bancaria').val();
		let monto               = $('#monto').val();
		let fecha               = $('#fecha').val();
		let observaciones       = $('#observaciones').val();
		let referencia_bancaria = $('#referencia_bancaria').val();
		let imagen              = $('#imagen').val();
		let grupo               = $('#grupo').val();
		let forma_pago          = $('#forma_pago').val();
		
		let domicilio_fiscal          = $('#domicilio_fiscal').val();
		let nombre_fiscal          = $('#nombre_fiscal').val();
		let rfc          = $('#rfc').val();

		turn_on_cargando();
			
		let data = "tarea=guardar_evidencia"
				 + "&nombre_agencia=" + nombre_agencia
				 + "&email=" + email
				 + "&reservacion=" + reservacion
				 + "&referencia_bancaria=" + referencia_bancaria
				 + "&cuenta_bancaria=" + cuenta_bancaria
				 + "&monto=" + monto
				 + "&fecha=" + fecha
				 + "&observaciones=" + observaciones
				 + "&imagen=" + imagen
				 + "&equipo=" + grupo
				 + "&forma_pago=" + forma_pago
				 + "&factura=" + factura
				 + "&domicilio_fiscal=" + domicilio_fiscal
				 + "&nombre_fiscal=" + nombre_fiscal
				 + "&rfc=" + rfc;
		console.log(data);

		$.ajax({
	        data:  data,
	        url:   './system/process/controlador.php',
	        type:  'POST',
	        beforeSend: function () {

	        },
	        error:  function () {
	            messageConfirmation("ERROR, al conectarse al SERVIDOR...","error");
	            turn_off_cargando();
	        },
	        success: function(data){
	        	turn_off_cargando();
	        	console.warn("RESPONSE: o"+ data+"o");
	        	var data_check = data.split("|");
	        	// imagenes("imagen","guardar_evidencia",data_check[1]);
	        	if (data_check[0] === "registered") {
	        		imagenes("imagen","guardar_evidencia",data_check[1]);

	        		message("Pago registrado...","success");
	        		redirection("");
	        	}else{
	        		message(data,"error");
	        	}
	        }
	   });
	}else{
		message("Completa los datos solicitados.","error");
	}
}